﻿//////////////////////////////////////////////
// PostProcessPass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class BlendState ;
	class Camera ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "Pass.h"

#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT PostProcessPass : public Pass
	{
		public :

			// Getters
			Shader* getShader () const ;
			bool getBackProcess () const ;
			BlendState* getBlendState () const ;
			Camera* getCamera () const ;

			// Setters
			void setShader (Shader* shade) ;
			virtual void setBackProcess (bool value) ;
			virtual void setBlendState (BlendState* state) ;
			void setCamera (Camera* cam) ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Constructor
			PostProcessPass (System* system) noexcept ;
		protected :		
		
			// Attributes
			// Resources to use
			Shader* _shader ;
			BlendState* _blendState ;
			Camera* _camera ;

			// Flags
			bool _backProcess ;
	} ;
}